
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ChairProduction")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="office_chairs")
y = m.addVar(vtype=GRB.INTEGER, name="dining_chairs")

# Set objective function
m.setObjective(120 * x + 180 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200 * x + 250 * y <= 20000, "budget_constraint")
m.addConstr(x + y <= 130, "demand_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of office chairs: {x.x}")
    print(f"Number of dining chairs: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

