
from gurobipy import *

# Create a model
m = Model("chair_stocking")

# Define the decision variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="office_chairs")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="dining_chairs")

# Define the objective function: maximize profit
m.setObjective(120*x1 + 180*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x1 + 250*x2 <= 20000, "budget_constraint")
m.addConstr(x1 + x2 <= 130, "demand_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Stock {x1.x} office chairs and {x2.x} dining chairs")
    print(f"Maximum profit: ${120*x1.x + 180*x2.x}")
else:
    print("No optimal solution found")

