
import gurobi

def leeside_designs_optimization():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="office_chairs", lb=0, ub=None, obj=120)
    y = model.addVar(name="dining_chairs", lb=0, ub=None, obj=180)

    # Add budget constraint
    model.addConstr(200 * x + 250 * y <= 20000, name="budget_constraint")

    # Add demand constraint
    model.addConstr(x + y <= 130, name="demand_constraint")

    # Set the objective function
    model.setObjective(x.obj * x + y.obj * y, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.x}, y = {y.x}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

    return model

# Run the optimization
model = leeside_designs_optimization()
