
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Nolan_Center_Concert")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="VIP_tickets")
y = model.addVar(vtype=GRB.INTEGER, name="General_tickets")

# Set objective function
model.setObjective(30*x + 14*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 200, "Capacity")
model.addConstr(x >= 20, "Min_VIP")
model.addConstr(y >= 4*x, "General_preference")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of VIP tickets to sell: {x.x}")
    print(f"Number of General tickets to sell: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

