
from gurobipy import *

# Create a model
m = Model("Concert_Seating")

# Define variables
V = m.addVar(vtype=GRB.INTEGER, name="VIP_seats")
G = m.addVar(vtype=GRB.INTEGER, name="General_seats")

# Set the objective function to maximize profit
m.setObjective(30*V + 14*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(V + G <= 200, "Total capacity constraint")
m.addConstr(V >= 20, "Minimum VIP seats constraint")
m.addConstr(G >= 4*V, "Preference ratio constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"VIP seats: {V.x}")
    print(f"General seats: {G.x}")
    print(f"Maximum profit: ${30*V.x + 14*G.x}")
else:
    print("No optimal solution found")

