
import gurobi

def maximize_profit():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="VIP_seats")  # Number of VIP seats
    y = model.addVar(lb=0, name="general_seats")  # Number of general seats

    # Objective function: Maximize profit
    model.setObjective(30*x + 14*y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 200, name="total_seats")
    model.addConstr(x >= 20, name="min_VIP_seats")
    model.addConstr(y >= 4*x, name="general_vs_VIP")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: VIP seats = {x.varValue}, General seats = {y.varValue}")
        print(f"Maximum profit: ${30*x.varValue + 14*y.varValue}")
    else:
        print("No optimal solution found")

maximize_profit()
