
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Furniture_Production")

# Create decision variables
desks_X = model.addVar(vtype=GRB.INTEGER, name="desks_X")
chairs_Y = model.addVar(vtype=GRB.INTEGER, name="chairs_Y")

# Set objective function
model.setObjective(140 * desks_X + 120 * chairs_Y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(desks_X <= 22, "Manufacturer_X_Capacity")
model.addConstr(chairs_Y <= 28, "Manufacturer_Y_Capacity")
model.addConstr(desks_X + chairs_Y <= 40, "Quality_Check_Capacity")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of desks from Manufacturer X: {desks_X.x}")
    print(f"Number of chairs from Manufacturer Y: {chairs_Y.x}")
    print(f"Total Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

