
from gurobipy import *

# Create a new model
m = Model("Furniture_Optimization")

# Define decision variables
D_X = m.addVar(lb=0, vtype=GRB.INTEGER, name="Desks_Made_By_X")
C_Y = m.addVar(lb=0, vtype=GRB.INTEGER, name="Chairs_Made_By_Y")

# Add constraints
m.addConstr(D_X <= 22, "Max_Desks_X")
m.addConstr(C_Y <= 28, "Max_Chairs_Y")
m.addConstr(D_X + C_Y <= 40, "Quality_Check_Limit")

# Set the objective function to maximize profit
m.setObjective(140*D_X + 120*C_Y, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Desks made by X: {D_X.x}, Chairs made by Y: {C_Y.x}")
else:
    print("No optimal solution found.")
