
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    D_x = model.addVar(lb=0, ub=22, name="D_x")  # Desks by Manufacturer X
    D_y = model.addVar(lb=0, name="D_y")  # Desks by Manufacturer Y
    C_x = model.addVar(lb=0, name="C_x")  # Chairs by Manufacturer X
    C_y = model.addVar(lb=0, ub=28, name="C_y")  # Chairs by Manufacturer Y

    # Objective function: Maximize profit
    model.setObjective(140 * (D_x + D_y) + 120 * (C_x + C_y), gurobi.GRB.MAXIMIZE)

    # Quality checking limit
    model.addConstr(D_x + D_y + C_x + C_y <= 40, name="Quality_Checking_Limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Desks by Manufacturer X: {D_x.varValue}")
        print(f"Desks by Manufacturer Y: {D_y.varValue}")
        print(f"Chairs by Manufacturer X: {C_x.varValue}")
        print(f"Chairs by Manufacturer Y: {C_y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
