
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("BurritoOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="bean_burritos") # Integer number of bean burritos
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="beef_burritos") # Integer number of beef burritos


# Set objective function
model.setObjective(6.5 * x + 9 * y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(25 * x + 18 * y <= 5000, "lettuce_constraint")
model.addConstr(y >= 4 * x, "beef_demand")
model.addConstr(x >= 5, "min_bean")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bean burritos (x): {x.x}")
    print(f"Number of beef burritos (y): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

