
from gurobipy import *

# Create a new model
m = Model("Burrito_Optimization")

# Define the decision variables
x_b = m.addVar(vtype=GRB.INTEGER, name="bean_burritos")
x_bf = m.addVar(vtype=GRB.INTEGER, name="beef_burritos")

# Define the objective function
m.setObjective(6.5*x_b + 9*x_bf, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x_b + 18*x_bf <= 5000, "lettuce_limit")
m.addConstr(x_bf >= 4*x_b, "beef_to_bean_ratio")
m.addConstr(x_b >= 5, "minimum_bean_burritos")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x_b.varName} = {x_b.x}, {x_bf.varName} = {x_bf.x}")
    print(f"Maximum profit: ${6.5*x_b.x + 9*x_bf.x:.2f}")
else:
    print("No optimal solution found")
