
import gurobipy as gp

# Create a new model
model = gp.Model("Burrito_Optimization")

# Decision variables
x = model.addVar(name="bean_burritos", lb=5, vtype=gp.GRB.INTEGER)  # At least 5 bean burritos
y = model.addVar(name="beef_burritos", vtype=gp.GRB.INTEGER)  # No lower bound specified, but will be constrained

# Objective function: Maximize profit
model.setObjective(6.5 * x + 9 * y, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(25 * x + 18 * y <= 5000, name="lettuce_constraint")  # Lettuce constraint
model.addConstr(y >= 4 * x, name="beef_to_bean_ratio")  # Beef to bean burrito ratio

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Bean Burritos = {x.varValue}, Beef Burritos = {y.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
