
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tea Production")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="Earl_Grey") # Earl Grey teabags
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="English_Breakfast") # English Breakfast teabags

# Set objective function
m.setObjective(0.30*x + 0.25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x + 20*y <= 3000, "Tea_Availability")
m.addConstr(x >= 4*y, "Demand")
m.addConstr(y >= 20, "Min_English_Breakfast")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Earl Grey Teabags: {x.x}")
    print(f"Optimal English Breakfast Teabags: {y.x}")
    print(f"Optimal Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

