
from gurobipy import *

# Create a new model
m = Model("Tea_Profit_Maximization")

# Define variables
x = m.addVar(name="Earl_Grey_Teabags", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="English_Breakfast_Teabags", vtype=GRB.CONTINUOUS, lb=20)

# Set the objective function
m.setObjective(0.30*x + 0.25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x + 20*y <= 3000, name="Black_Tea_Availability")
m.addConstr(x >= 4*y, name="Demand_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Earl Grey Teabags: {x.x}")
    print(f"English Breakfast Teabags: {y.x}")
    print(f"Maximum Profit: ${0.30*x.x + 0.25*y.x:.2f}")
else:
    print("No optimal solution found")
