
import gurobi

def solve_tea_bag_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="earl_grey", obj=0.30)  # Number of earl grey teabags
    y = model.addVar(name="english_breakfast", obj=0.25)  # Number of English breakfast teabags

    # Black tea availability constraint
    model.addConstr(25 * x + 20 * y <= 3000, name="black_tea_availability")

    # Demand constraint for earl grey vs english breakfast
    model.addConstr(x >= 4 * y, name="demand_earl_grey")

    # Minimum English breakfast teabags constraint
    model.addConstr(y >= 20, name="min_english_breakfast")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: earl grey = {x.varValue}, english breakfast = {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found")

solve_tea_bag_problem()
