
import gurobipy as gp

# Create a new model
m = gp.Model("soup_optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="crab_soup")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="lobster_soup")

# Set objective function
m.setObjective(3*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x + 10*y <= 80, "water_constraint")
m.addConstr(8*x <= 65, "crab_meat_constraint")
m.addConstr(5*y <= 55, "lobster_meat_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Crab soup servings: {x.x:.2f}")
    print(f"Lobster soup servings: {y.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

