
from gurobipy import *

# Create a model
m = Model("soup_profit_maximization")

# Decision variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="crab_soup_servings")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lobster_soup_servings")

# Objective function: Maximize profit
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x1 + 10*x2 <= 80, "water_constraint")
m.addConstr(8*x1 <= 65, "crab_meat_constraint")
m.addConstr(5*x2 <= 55, "lobster_meat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Crab soup servings: {x1.x}")
    print(f"Lobster soup servings: {x2.x}")
else:
    print("No optimal solution found")
