
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(lb=0, name="crab_soup")
y = model.addVar(lb=0, name="lobster_soup")

# Define the objective function
model.setObjective(3*x + 5*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(7*x + 10*y <= 80, name="water_constraint")
model.addConstr(8*x <= 65, name="crab_meat_constraint")
model.addConstr(5*y <= 55, name="lobster_meat_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Crab soup servings: {x.varValue}")
    print(f"Lobster soup servings: {y.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
