
import gurobipy as gp

# Create a new model
model = gp.Model("wood_shop_optimization")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cutting_boards")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knife_handles")

# Set objective function
model.setObjective(100*x + 250*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 30, "cutting_board_capacity")
model.addConstr(y <= 50, "knife_handle_capacity")
model.addConstr(5*x + 10*y <= 200, "labor_hours")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Cutting Boards (x): {x.x}")
    print(f"Knife Handles (y): {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

