
from gurobipy import *

# Create a new model
m = Model("Wood_Shop_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="Cutting_Boards")
x2 = m.addVar(lb=0, name="Knife_Handles")

# Set objective function
m.setObjective(100*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 30, "Max_Cutting_Boards")
m.addConstr(x2 <= 50, "Max_Knife_Handles")
m.addConstr(5*x1 + 10*x2 <= 200, "Labor_Hours")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
else:
    print("No optimal solution found")

