
import gurobi

def wood_shop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, ub=30, name="cutting_boards")
    y = model.addVar(lb=0, ub=50, name="knife_handles")

    # Objective function: Maximize profit
    model.setObjective(100*x + 250*y, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x <= 30, name="cutting_boards_limit")
    model.addConstr(y <= 50, name="knife_handles_limit")
    model.addConstr(5*x + 10*y <= 200, name="time_limit")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cutting Boards: {x.varValue}")
        print(f"Knife Handles: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

# Run the optimization
wood_shop_optimization()
