
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Seafood_Processing")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="crabs")  # Number of crabs
y = m.addVar(vtype=GRB.INTEGER, name="lobsters") # Number of lobsters

# Set objective function
m.setObjective(14*x + 18*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 5*y <= 400, "cleaning_time")
m.addConstr(15*x + 12*y <= 900, "shelling_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of crabs to process: {x.x}")
    print(f"Number of lobsters to process: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

