
from gurobipy import *

# Create a new model
m = Model("Crab_and_Lobster_Processing")

# Define variables
x = m.addVar(name="crabs", vtype=GRB.INTEGER, lb=0)  # Number of crabs
y = m.addVar(name="lobsters", vtype=GRB.INTEGER, lb=0)  # Number of lobsters

# Objective function: Maximize profit
m.setObjective(14*x + 18*y, GRB.MAXIMIZE)

# Constraints
# 1. Cleaning time constraint
m.addConstr(4*x + 5*y <= 400, name="cleaning_time")

# 2. Shelling time constraint
m.addConstr(15*x + 12*y <= 900, name="shelling_time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: ${14*x.x + 18*y.x}")
else:
    print("No optimal solution found")
