
import gurobi

# Create a new model
m = gurobi.Model()

# Define the decision variables
c = m.addVar(lb=0, name="crabs")
l = m.addVar(lb=0, name="lobsters")

# Define the objective function
m.setObjective(14*c + 18*l, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(4*c + 5*l <= 400, name="cleaning_time")
m.addConstr(15*c + 12*l <= 900, name="shelling_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Crabs: {c.varValue}")
    print(f"Lobsters: {l.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
