
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Oil_Production")

# Create variables
x_e = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Economical")
x_r = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Regular")
x_p = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Premium")

# Set objective function
m.setObjective(500*x_e + 1020*x_r + 920*x_p, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x_e + 5*x_r + 8*x_p <= 200, "Compound_A")
m.addConstr(2*x_e + 1*x_r + 1*x_p <= 100, "Compound_B")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Economical Oil: {x_e.x} tankers")
    print(f"Regular Oil: {x_r.x} tankers")
    print(f"Premium Oil: {x_p.x} tankers")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

