
from gurobipy import *

# Create a new model
m = Model("Oil_Production")

# Define the decision variables
E = m.addVar(lb=0, name="Economical")
R = m.addVar(lb=0, name="Regular")
P = m.addVar(lb=0, name="Premium")

# Set the objective function to maximize net revenue
m.setObjective(500*E + 1020*R + 920*P, GRB.MAXIMIZE)

# Add constraints for compound A and B availability
m.addConstr(4*E + 5*R + 8*P <= 200, name="Compound_A")
m.addConstr(2*E + R + P <= 100, name="Compound_B")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Economical: {E.x:.2f} tankers")
    print(f"Regular: {R.x:.2f} tankers")
    print(f"Premium: {P.x:.2f} tankers")
    print(f"Total Revenue: ${m.objVal:.2f}")
else:
    print("No optimal solution found")

