
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(name="apple_acres")  # Acres of apple trees
y = m.addVar(name="peach_acres")  # Acres of peach trees

# Set objective function
m.setObjective(900*x + 1100*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 400, "land_constraint")
m.addConstr(x >= 60, "min_apple")
m.addConstr(y >= 40, "min_peach")
m.addConstr(y <= 3*x, "peach_apple_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of apple trees")
    print(f"Plant {y.x} acres of peach trees")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status {m.status}")

