
from gurobipy import *

# Create a model
m = Model("Farmer_Profit")

# Define variables
A = m.addVar(lb=60, name="Apple_Acres")  # At least 60 acres of apple trees
P = m.addVar(lb=40, name="Peach_Acres")  # At least 40 acres of peach trees

# Define constraints
m.addConstr(A + P <= 400, name="Total_Land")  # Total land constraint
m.addConstr(P <= 3 * A, name="Peach_to_Apple_Ratio")  # Peach to apple ratio constraint

# Define the objective function
m.setObjective(900 * A + 1100 * P, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Acres: {A.x}")
    print(f"Peach Acres: {P.x}")
    print(f"Total Profit: ${900 * A.x + 1100 * P.x}")
else:
    print("No optimal solution found")

