
import gurobi

def solve_farmer_problem():
    # Create a new model
    m = gurobi.Model()

    # Define the variables
    A = m.addVar(lb=0, name="Apple acres")
    P = m.addVar(lb=0, name="Peach acres")

    # Objective function: Maximize profit
    m.setObjective(900*A + 1100*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(A >= 60, name="Min Apple acres")
    m.addConstr(P >= 40, name="Min Peach acres")
    m.addConstr(P <= 3*A, name="Peach vs Apple ratio")
    m.addConstr(A + P <= 400, name="Total land constraint")

    # Update model
    m.update()

    # Solve the model
    m.optimize()

    # Print the results
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of apple trees: {A.varValue}")
        print(f"Optimal acres of peach trees: {P.varValue}")
        print(f"Max Profit: ${900*A.varValue + 1100*P.varValue}")
    else:
        print("The model is infeasible")

solve_farmer_problem()
