
import gurobipy as gp

# Create a new model
m = gp.Model("hockey_concessions")

# Create variables
c = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="coffees")
h = m.addVar(lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER, name="hot_chocolates")

# Set objective
m.setObjective(0.22 * c + 0.14 * h, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(c >= 40, "min_coffees")
m.addConstr(h >= 20, "min_hot_chocolates")
m.addConstr(c <= 60, "max_coffees")
m.addConstr(h <= 35, "max_hot_chocolates")
m.addConstr(c + h <= 75, "total_items")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of coffees to sell: {c.x}")
    print(f"Number of hot chocolates to sell: {h.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

