
from gurobipy import *

# Create a new model
m = Model("coffee_hot_chocolate")

# Define the decision variables
C = m.addVar(lb=40, ub=60, vtype=GRB.INTEGER, name="coffees")
H = m.addVar(lb=20, ub=35, vtype=GRB.INTEGER, name="hot_chocolates")

# Define the objective function: maximize profit
m.setObjective(0.22*C + 0.14*H, GRB.MAXIMIZE)

# Add constraint for total items
m.addConstr(C + H <= 75, "total_items")

# Optimize model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coffees to sell: {C.x}")
    print(f"Hot chocolates to sell: {H.x}")
    print(f"Maximum profit: ${0.22*C.x + 0.14*H.x:.2f}")
else:
    print("No optimal solution found")
