
import gurobi

def solve_vendor_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables with integer requirement
    x = model.addVar(lb=40, ub=60, vtype=gurobi.GRB.INTEGER, name="coffees")
    y = model.addVar(lb=20, ub=35, vtype=gurobi.GRB.INTEGER, name="hot_chocolates")

    # Objective function: Maximize profit
    model.setObjective(0.22 * x + 0.14 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 75, name="total_items")

    # Update model
    model.update()

    # Solve
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: {model.objVal}")
        print(f"Coffees to sell: {x.varValue}")
        print(f"Hot chocolates to sell: {y.varValue}")
    else:
        print("No optimal solution found")

if __name__ == "__main__":
    solve_vendor_problem()
