
from gurobipy import *

# Create a model
model = Model("Bubble_Tea_Optimization")

# Define variables
T = model.addVar(vtype=GRB.CONTINUOUS, name="taro_bubble_teas", lb=0)
M = model.addVar(vtype=GRB.CONTINUOUS, name="mango_bubble_teas", lb=0)

# Objective function: Maximize profit
model.setObjective(4*T + 6*M, GRB.MAXIMIZE)

# Constraints
model.addConstr(3*T <= 60, "taro_availability")
model.addConstr(3*M <= 60, "mango_availability")
model.addConstr(4*T + 5*M <= 140, "milk_availability")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Taro bubble teas: {T.x}")
    print(f"Mango bubble teas: {M.x}")
    print(f"Total profit: ${4*T.x + 6*M.x:.2f}")
else:
    print("No optimal solution found")

