
import gurobipy as gp

# Create a new model
model = gp.Model("bubble_tea")

# Define the decision variables
taro_bubble_tea = model.addVar(lb=0, name="taro_bubble_tea")
mango_bubble_tea = model.addVar(lb=0, name="mango_bubble_tea")

# Define the objective function
model.setObjective(4 * taro_bubble_tea + 6 * mango_bubble_tea, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(3 * taro_bubble_tea <= 60, name="taro_constraint")
model.addConstr(3 * mango_bubble_tea <= 60, name="mango_constraint")
model.addConstr(4 * taro_bubble_tea + 5 * mango_bubble_tea <= 140, name="milk_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Taro bubble tea: {taro_bubble_tea.varValue}")
    print(f"Mango bubble tea: {mango_bubble_tea.varValue}")
    print(f"Profit: {model.objVal}")
else:
    print("No optimal solution found.")
