
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Eli's Farming Problem")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="beans") # Acres of beans
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pumpkins") # Acres of pumpkins

# Set objective function
m.setObjective(100*x + 110*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land")
m.addConstr(x >= 5, "min_beans")
m.addConstr(y >= 10, "min_pumpkins")
m.addConstr(y >= x, "pumpkin_preference")
m.addConstr(y <= 3*x, "labor")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of beans")
    print(f"Plant {y.x} acres of pumpkins")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

