
from gurobipy import *

# Create a new model
m = Model("Eli_Farm_Problem")

# Define variables
B = m.addVar(lb=5, name="beans")  # Minimum acres of beans is 5
P = m.addVar(lb=10, name="pumpkins")  # Minimum acres of pumpkins is 10

# Add constraints
m.addConstr(B + P <= 100, name="total_acres")
m.addConstr(P <= 3 * B, name="labor_constraint")

# Objective function: Maximize profit
m.setObjective(100 * B + 110 * P, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal acres of beans to plant: {B.x}")
    print(f"Optimal acres of pumpkins to plant: {P.x}")
    print(f"Maximum profit achievable: ${m.objVal}")
else:
    print("Problem is infeasible or unbounded.")
