
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=5, name="Beans")  # Minimum 5 acres of beans
    P = model.addVar(lb=10, name="Pumpkins")  # Minimum 10 acres of pumpkins

    # Objective function: Maximize profit
    model.setObjective(100 * B + 110 * P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(B + P <= 100, name="Total_Acres")  # Total acres constraint
    model.addConstr(P <= 3 * B, name="Pumpkins_to_Beans_Ratio")  # Pumpkins to beans ratio constraint

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Acres of beans: {B.varValue}, Acres of pumpkins: {P.varValue}")
        print(f"Maximum profit: ${100 * B.varValue + 110 * P.varValue}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
