
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("video_game_stock")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="regular_games")
y = m.addVar(vtype=GRB.INTEGER, name="collectors_games")

# Set objective function
m.setObjective(20 * x + 30 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "total_games")
m.addConstr(30 * x + 50 * y <= 4000, "total_cost")
m.addConstr(x >= 0, "non_neg_x")
m.addConstr(y >= 0, "non_neg_y")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of regular games to stock: {x.x}")
    print(f"Number of collector's edition games to stock: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

