
from gurobipy import *

# Create a new model
m = Model("Video_Game_Store")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_games")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="collectors_edition_games")

# Set the objective function
m.setObjective(20*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 50*y <= 4000, "budget_constraint")
m.addConstr(x <= 100, "regular_game_limit")
m.addConstr(y <= 100, "collectors_edition_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Stock {x.x} regular games and {y.x} collector's edition games.")
    print(f"Maximum profit: ${20*x.x + 30*y.x}")
else:
    print("No optimal solution found.")
