
import gurobi as gp

# Create a new model
model = gp.Model("VideoGameStore")

# Define variables
R = model.addVar(vtype=gp.GRB.INTEGER, name="Regular_Games")
C = model.addVar(vtype=gp.GRB.INTEGER, name="Collectors_Edition_Games")

# Objective function: Maximize profit
model.setObjective(20*R + 30*C, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(R + C <= 100, name="Sales_Limit")
model.addConstr(30*R + 50*C <= 4000, name="Budget_Constraint")
model.addConstr(R >= 0, name="Non_Negativity_R")
model.addConstr(C >= 0, name="Non_Negativity_C")

# Optimize
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal stock of regular games: {R.varValue}")
    print(f"Optimal stock of collector's edition games: {C.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("No optimal solution found.")
