
import gurobipy as gp

# Create a new model
model = gp.Model("ConsoleProduction")

# Create decision variables
x = model.addVar(lb=0, name="PX7")
y = model.addVar(lb=0, name="SilentX")

# Set objective function
model.setObjective(40 * x + 75 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 2 * y, "Demand")
model.addConstr(3 * x + 7 * y <= 48, "Labor")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of PX7 consoles: {x.x}")
    print(f"Number of Silent X consoles: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

