
from gurobipy import *

# Create a model
m = Model("ConsoleProduction")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="PX7_Consoles")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="SilentX_Consoles")

# Set the objective function: Maximize profit
m.setObjective(40*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 7*x2 <= 48, "LaborConstraint")
m.addConstr(x1 >= 2*x2, "DemandForecastConstraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f" Produce {x1.x} PX7 consoles")
    print(f" Produce {x2.x} SilentX consoles")
    print(f" Maximum Profit: ${40*x1.x + 75*x2.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
