
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="PX7", vtype=gurobi.GRB.INTEGER, lb=0)  # Number of PX7 consoles
    y = model.addVar(name="Silent_X", vtype=gurobi.GRB.INTEGER, lb=0)  # Number of Silent X consoles

    # Objective function: Maximize profit
    model.setObjective(40 * x + 75 * y, sense=gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x >= 2 * y, name="PX7_to_SilentX_ratio")
    model.addConstr(3 * x + 7 * y <= 48, name="Labor_hours_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: {x.varName} = {x.x}, {y.varName} = {y.x}")
        print(f"Maximum profit: ${40 * x.x + 75 * y.x:.2f}")
    else:
        print("The problem is infeasible.")

solve_production_problem()
