
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Glass Production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bulletproof")  # Bulletproof panes
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fire_rated")  # Fire-rated panes

# Set objective function
model.setObjective(12*x + 9.5*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x + 7*y <= 350, "heating_constraint")
model.addConstr(6*x + 9*y <= 350, "cooling_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bulletproof panes: {x.x}")
    print(f"Number of fire-rated panes: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

