
from gurobipy import *

# Create a model
m = Model("Glass_Production")

# Define decision variables
x = m.addVar(lb=0, name="bulletproof_glass_panes")
y = m.addVar(lb=0, name="fire_rated_glass_panes")

# Objective function: Maximize profit
m.setObjective(12*x + 9.5*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(4*x + 7*y <= 350, name="heating_machine_constraint")
m.addConstr(6*x + 9*y <= 350, name="cooling_machine_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bulletproof glass panes: {x.x}")
    print(f"Fire-rated glass panes: {y.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
