
import gurobi

def solve_alpha_glass_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="bulletproof", lb=0, ub=None)  # Number of bulletproof glass panes
    y = model.addVar(name="fire-rated", lb=0, ub=None)  # Number of fire-rated glass panes

    # Objective function: Maximize profit
    model.setObjective(12 * x + 9.5 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x + 7 * y <= 350, name="heating_machine")
    model.addConstr(6 * x + 9 * y <= 350, name="cooling_machine")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_alpha_glass_problem()
