
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x = m.addVar(lb=0, name="vegetables") # Servings of vegetables
    y = m.addVar(lb=0, name="grains") # Servings of grains

    # Set objective function
    m.setObjective(0.6*x + 0.4*y, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*x + 30*y >= 100, "iron_req")
    m.addConstr(25*x + 5*y >= 150, "fiber_req")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print(f"Optimal Cost: ${m.objVal:.2f}")
        print(f"Servings of Vegetables: {x.x:.2f}")
        print(f"Servings of Grains: {y.x:.2f}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
