
from gurobipy import *

# Create a new model
m = Model("Food_Optimization")

# Define the decision variables
G = m.addVar(lb=0, name="Grains")
V = m.addVar(lb=0, name="Vegetables")

# Set the objective function to minimize cost
m.setObjective(0.40*G + 0.60*V, GRB.MINIMIZE)

# Add constraints for iron and fiber requirements
m.addConstr(15*V + 30*G >= 100, "Iron_Requirement")
m.addConstr(25*V + 5*G >= 150, "Fiber_Requirement")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grains: {G.x}")
    print(f"Vegetables: {V.x}")
    print(f"Total Cost: ${0.40*G.x + 0.60*V.x:.2f}")
else:
    print("No optimal solution found")

