
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="grains", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="vegetables", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(0.40 * x + 0.60 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(30 * x + 15 * y >= 100, name="iron_requirement")
    model.addConstr(5 * x + 25 * y >= 150, name="fiber_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Servings of grains: {x.varValue}")
        print(f"Servings of vegetables: {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

if __name__ == "__main__":
    solve_optimization_problem()
