
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("basketball_shots")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="long_shots")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mid_range_shots")


# Set objective function
m.setObjective(0.25 * x + 0.4 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * 0.25 * x + 2 * 0.4 * y >= 95, "total_points")
m.addConstr(x >= 5, "min_long_shots")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of long shots: {x.x}")
    print(f"Number of mid-range shots: {y.x}")
    print(f"Total Efficiency: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

